//AIM:Four point IDIT-FFT without using inbuilt Scilab FFT function
// (This is an extra solution)

//Computing four point IDFT for X(k)={10,-2+2j,-2,-2-2j} using 
//Inverse Decimation in Time-Fast Fourier transform (i.e. IDIT-FFT )
//without using readymade inbuilt Scilab functions for IDFT/IFFT.

//Software version Scilab 5.5.2
//OS windows 10
clc;
clear;
//Let us begin with the programming.For understanding,let us write the given
//data as
//X(0)=10;X(1)=-2+2j,X(2)=-2,X(3)=-2-2j
X0_conj=10;//X0_conj means complex conjugate of XO
X2_conj=-2;//X2_conj means complex conjugate of X2
X1_conj=(-2)+((-1)*(2)*(sqrt(-1)));//X1_conj means complex conjugate of X1
X3_conj=(-2)-((-1)*(2)*(sqrt(-1)));//X3_conj means complex conjugate of X3
disp(X0_conj,'X*(0)=')
disp(X2_conj,'X*(2)=')
disp(X1_conj,'X*(1)=')
disp(X3_conj,'X*(3)=')
//Stage I computation
X0a=X2_conj+X0_conj;//Computing Stage-I output at line 1
disp(X0a,'Stage-I output at line 1')
X2b=(X2_conj-X0_conj)*(-1);//Computing Stage-I output at line 2
disp(X2b,'Stage-I output at line 2')
X1c=X3_conj+X1_conj;//Computing Stage-I output at line 3
disp(X1c,'Stage-I output at line 3')
X3d=(X3_conj-X1_conj)*(-1);//Computing Stage-I output at line 4
disp(X3d,'Stage-I output at line 4')
//Stage II computation
X3d1=X3d*(-sqrt(-1));// Multiply by (-j) in the last line
disp(X3d1,'Stage-II input at the fourth line ')
x0_star=X1c+X0a;//Computing stage-II output value at line 1
disp(x0_star,'The stage-II output value at line 1=')
x1_star=X3d1+X2b;//Computing stage-II output value at line 2
disp(x1_star,'The stage-II output value at line 2 =')
x2_star=(X1c-X0a)*(-1);//Computing stage-II output value at line 3
disp(x2_star,'The stage-II output valueat line 3=')
x3_star=(X3d1-X2b)*(-1);//Computing stage-II output value at line 4
disp(x3_star,'The stage-II output value at line 4=')
//Now we will multiply stage-II output values individually with a factor of
//(1/N). Here N=4,So we will multiply by (1/4)
x0_star_on_multiplication=(1/4)*(x0_star);//Multiply by(1/4)
disp(x0_star_on_multiplication,'x*(0)=')
x1_star_on_multiplication=(1/4)*(x1_star);//Multiply by(1/4)
disp(x1_star_on_multiplication,'x*(1)=')
x2_star_on_multiplication=(1/4)*(x2_star);//Multiply by(1/4)
disp(x2_star_on_multiplication,'x*(2)=')
x3_star_on_multiplication=(1/4)*(x3_star);//Multiply by(1/4)
disp(x3_star_on_multiplication,'x*(3)=')
disp({,x0_star_on_multiplication,x1_star_on_multiplication,x2_star_on_multiplication,x3_star_on_multiplication,},'x*(n)=')
x0_star_real=real(x0_star_on_multiplication);
x0_star_conj=(-1)*(imag(x0_star_on_multiplication));
x1_star_real=real(x1_star_on_multiplication);
x1_star_conj=(-1)*(imag(x1_star_on_multiplication));
x2_star_real=real(x2_star_on_multiplication);
x2_star_conj=(-1)*(imag(x2_star_on_multiplication));
x3_star_real=real(x3_star_on_multiplication);
x3_star_conj=(-1)*(imag(x3_star_on_multiplication));
x0=x0_star_real+x0_star_conj
x1=x1_star_real+x1_star_conj
x2=x2_star_real+x2_star_conj
x3=x3_star_real+x3_star_conj
disp({,x0,x1,x2,x3,},'So,the IDFT of X(k) using Inverse Decimation-in-Time Fast Fourier Transform(IDIT-FFT) is x(n)=')


